﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Linq;

namespace PersonSearch.Plugin.VistA
{
    class VistaSiteService
    {
        internal static string GetSiteName(string siteId, IOrganizationService crmService)
        {
            var query = new QueryByAttribute("ftp_facility");
            query.AddAttributeValue("ftp_facilitycode", siteId);
            query.ColumnSet = new ColumnSet("ftp_name");
            var sitelist = crmService.RetrieveMultiple(query);
            return sitelist != null && sitelist.Entities.Any() ? (string)sitelist[0].Attributes["ftp_name"] + "&siteid=" + (string)sitelist[0].Attributes["ftp_facilityid"].ToString() : siteId;
        }

        internal static Guid? GetSiteCrmId(string siteCode, IOrganizationService crmService)
        { 
            var query = new QueryByAttribute("ftp_facility");
            query.AddAttributeValue("ftp_facilitycode", siteCode);
            query.ColumnSet = new ColumnSet("ftp_facilityid");
            var sitelist = crmService.RetrieveMultiple(query);
            return sitelist != null && sitelist.Entities.Any() ? (Guid)sitelist[0].Attributes["ftp_facilityid"] : (Guid?)null;
        }
        //internal static string GetSiteName(string siteId, IOrganizationService crmService)
        //{
        //    var query = new QueryByAttribute("ftp_vistasite");
        //    query.AddAttributeValue("ftp_siteid", siteId);
        //    query.ColumnSet = new ColumnSet("ftp_name");
        //    var sitelist = crmService.RetrieveMultiple(query);
        //    return sitelist != null && sitelist.Entities.Any() ? (string)sitelist[0].Attributes["ftp_name"] : siteId;
        //}

        //internal static Guid? GetSiteCrmId(string siteCode, IOrganizationService crmService)
        //{
        //    var query = new QueryByAttribute("ftp_vistasite");
        //    query.AddAttributeValue("ftp_siteid", siteCode);
        //    query.ColumnSet = new ColumnSet("ftp_siteid");
        //    var sitelist = crmService.RetrieveMultiple(query);
        //    return sitelist != null && sitelist.Entities.Any() ? (Guid)sitelist[0].Attributes["ftp_siteid"] : (Guid?)null;
        //}
    }
}
